#include<stdio.h>
#include<pthread.h>
#include<stdlib.h>
#include<unistd.h>
#include<time.h>

#define THREADS 10
#define AUTO 1
#define AUTOBUS 2
#define KAMION 3

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

int broj_automobilaS = 0;
int broj_autobusaS = 0;
int broj_kamionaS = 0;
int broj_automobilaJ = 0;
int broj_autobusaJ = 0;
int broj_kamionaJ = 0;
int vozila_severno = 0;
int vozila_juzno = 0;
int smer = 0; // 0 - nema nikog, 1 - sever, 2 - jug
int smerovi[THREADS] = {0};

void *sever(void *arg)
{
    long id = (long)arg;
    int tip_vozila = (rand() % 3) + 1;

    sleep(rand() % 10);
    if(tip_vozila == 1)
        printf("Automobil %ld zeli da ide na sever\n", id);
    else if(tip_vozila == 2)
        printf("Autobus %ld zeli da ide na sever\n", id);
    else
        printf("Kamion %ld zeli da ide na sever\n", id);

    pthread_mutex_lock(&mutex);
    if(vozila_juzno > 0 || broj_kamionaS > 0 || (tip_vozila == 3 && vozila_severno > 0) || (broj_autobusaS > 0 && tip_vozila == 2))
    {
        if(vozila_juzno > 0 )
            printf("Vozilo %ld mora da saceka jug\n", id);
        if(broj_autobusaS > 0 && tip_vozila == 2)
            printf("Vozilo %ld mora da saceka autobus\n", id);
        if(broj_kamionaS > 0)
            printf("Vozilo %ld mora da saceka kamion\n", id);
        if(tip_vozila == 3 && vozila_severno > 0)
            printf("Kamion %ld mora da ceka da svi prodju\n", id);
        pthread_cond_wait(&cond, &mutex);
    }

    if(tip_vozila == 1)
        broj_automobilaS++;
    else if(tip_vozila == 2)
        broj_autobusaS++;
    else
        broj_kamionaS++;

    vozila_severno++;
    pthread_mutex_unlock(&mutex);

    if(tip_vozila == 1)
        printf("Automobil %ld prelazi nadvoznjak sa severa\n", id);
    else if(tip_vozila == 2)
        printf("Autobus %ld prelazi nadvoznjak sa severa\n", id);
    else
        printf("Kamion %ld prelazi nadvoznjak sa severa\n", id);
    sleep(2);

    pthread_mutex_lock(&mutex);

    vozila_severno--;

    if(tip_vozila == 1)
        broj_automobilaS--;
    else if(tip_vozila == 2)
        broj_autobusaS--;
    else
        broj_kamionaS--;

    printf("Vozilo %ld je proslo nadvoznjak sa severa\n", id);

    if(vozila_severno == 0)
    {
        smer = 0;
        pthread_cond_broadcast(&cond);
    }

    pthread_mutex_unlock(&mutex);

}

void *jug(void *arg)
{
    long id = (long)arg;

    int tip_vozila = (rand() % 3) + 1;

    sleep(rand() % 10);
    if(tip_vozila == 1)
        printf("Automobil %ld zeli da ide na jug\n", id);
    else if(tip_vozila == 2)
        printf("Autobus %ld zeli da ide na jug\n", id);
    else
        printf("Kamion %ld zeli da ide na jug\n", id);
    pthread_mutex_lock(&mutex);
    if(vozila_severno > 0 || broj_kamionaJ > 0 || (tip_vozila == 3 && vozila_juzno > 0) || (broj_autobusaJ > 0 && tip_vozila == 2)) 
    {
        if(vozila_severno > 0 )
            printf("Vozilo %ld mora da saceka sever\n", id);
        if(broj_autobusaJ > 0 && tip_vozila == 2)
            printf("Vozilo %ld mora da saceka autobus\n", id);
        if(broj_kamionaJ > 0)
            printf("Vozilo %ld mora da saceka kamion\n", id);
        if(tip_vozila == 3 && vozila_juzno > 0)
            printf("Kamion %ld mora da saceka da svi prodju\n", id);
        pthread_cond_wait(&cond, &mutex);
    }

    if(tip_vozila == 1)
        broj_automobilaJ++;
    else if(tip_vozila == 2)
        broj_autobusaJ++;
    else
        broj_kamionaJ++;
    
    vozila_juzno++;
    
    pthread_mutex_unlock(&mutex);

    if(tip_vozila == 1)
        printf("Automobil %ld prelazi nadvoznjak sa juga\n", id);
    else if(tip_vozila == 2)
        printf("Autobus %ld prelazi nadvoznjak sa juga\n", id);
    else
        printf("Kamion %ld prelazi nadvoznjak sa juga\n", id);
    sleep(2);

    pthread_mutex_lock(&mutex);

    vozila_juzno--;

    if(tip_vozila == 1)
        broj_automobilaJ--;
    else if(tip_vozila == 2)
        broj_autobusaJ--;
    else
        broj_kamionaJ--;
    
    printf("Vozilo %ld je proslo nadvoznjak sa juga\n", id);

    if(vozila_juzno == 0)
    {
        smer = 0;
        pthread_cond_broadcast(&cond);
    }

    
    pthread_mutex_unlock(&mutex);
}

int main()
{
    pthread_t threads[THREADS];
    
    srand(time(NULL));
    
    for(long i = 0; i < THREADS; i++)
    {
        int tip = (rand() % 2) + 1;
        if(tip == 1)
            pthread_create(threads + i, NULL, sever, (void *)i);
        else
            pthread_create(threads + i, NULL, jug, (void *)i);
    }

    for(long i = 0; i < THREADS; i++)
        pthread_join(threads[i], NULL);

    pthread_exit(NULL);
}